% Road_normality_test
% Testuje normalitu nahodne cesty
%-------------------------------------------------------------------------
% Witten By Tomas Mauder, VUT v Brne, 2014.
%-------------------------------------------------------------------------
function Road_normality_test(z,graphs)


% prumer
mu = mean(z);

% smerodatna odchylka
sigma = std(z);

% rozptyl
sigma_2 = var(z);

%-------------------------------------------------------------------------
% Ch2 test normality o neznamem rozptylu se stredni hodnotou me = 0

NN = round(size(z,2)/10);
[n,xout] = hist(z,NN)	;
AA = [normcdf((xout(1:end-1) + xout(2:end))/2,mu,sigma) 1];

 for i = 2:NN
 B(i) = AA(i) - AA(i-1);
 end
 B(1) = AA(1);

for j = 1:NN
    D(j) = B(j) * size(z,2);   
end

for i = 1:NN
X(i) = (n(i) - D(i))^2/D(i);
end

chi2 = chi2inv(1-0.05,NN-1);
if sum(X) < chi2
disp('Nelze vyvratit hypotezu o normalnim rozdeleni na alfa = 0.05')
else
disp('Hypoteza o normalnim rozdeleni byla vyvracena na alfa = 0.05')
end 
%-------------------------------------------------------------------------
if graphs == 1

figure
normplot(z)

figure
histfit(z,NN)

end

